CREATE DATABASE  IF NOT EXISTS `bank2` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;
USE `bank2`;
-- MySQL dump 10.13  Distrib 8.0.22, for Win64 (x86_64)
--
-- Host: localhost    Database: bank2
-- ------------------------------------------------------
-- Server version	8.0.22

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `konto`
--

DROP TABLE IF EXISTS `konto`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `konto` (
  `kontoNr` int NOT NULL AUTO_INCREMENT,
  `kontostand` decimal(10,0) NOT NULL DEFAULT '0',
  `name` varchar(45) NOT NULL,
  PRIMARY KEY (`kontoNr`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `konto_kunde`
--

DROP TABLE IF EXISTS `konto_kunde`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `konto_kunde` (
  `kundenNr_fk` int NOT NULL,
  `kontoNr_fk` int NOT NULL,
  `rolle` varchar(45) NOT NULL,
  PRIMARY KEY (`kundenNr_fk`,`kontoNr_fk`,`rolle`),
  KEY `fk_konto_kunde_konto_idx` (`kontoNr_fk`),
  CONSTRAINT `fk_konto_kunde_konto` FOREIGN KEY (`kontoNr_fk`) REFERENCES `konto` (`kontoNr`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_konto_kunde_kunde` FOREIGN KEY (`kundenNr_fk`) REFERENCES `kunde` (`kundenNr`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `kunde`
--

DROP TABLE IF EXISTS `kunde`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `kunde` (
  `kundenNr` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `adresse` varchar(45) NOT NULL,
  `geburtsdatum` date NOT NULL,
  PRIMARY KEY (`kundenNr`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `transaktion`
--

DROP TABLE IF EXISTS `transaktion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `transaktion` (
  `transaktionsNr` int NOT NULL AUTO_INCREMENT,
  `betrag` decimal(10,0) NOT NULL,
  `zeitstempel` datetime NOT NULL,
  `quelle_kontoNr_fk` int DEFAULT NULL,
  `ziel_kontoNr_fk` int DEFAULT NULL,
  PRIMARY KEY (`transaktionsNr`),
  KEY `fk_quelle_konto_transaktion_idx` (`quelle_kontoNr_fk`),
  KEY `fk_ziel_konto_transaktion_idx` (`ziel_kontoNr_fk`),
  CONSTRAINT `fk_quelle_konto_transaktion` FOREIGN KEY (`quelle_kontoNr_fk`) REFERENCES `konto` (`kontoNr`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `fk_ziel_konto_transaktion` FOREIGN KEY (`ziel_kontoNr_fk`) REFERENCES `konto` (`kontoNr`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2021-11-25 11:08:57
