CREATE DATABASE  IF NOT EXISTS `uebungsfirma` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;
USE `uebungsfirma`;
-- MySQL dump 10.13  Distrib 8.0.22, for Win64 (x86_64)
--
-- Host: localhost    Database: uebungsfirma
-- ------------------------------------------------------
-- Server version	8.0.22

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `abteilung`
--

DROP TABLE IF EXISTS `abteilung`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `abteilung` (
  `Abteilungsnummer` int NOT NULL AUTO_INCREMENT,
  `Name` varchar(45) NOT NULL,
  `Stockwerk` varchar(45) NOT NULL,
  PRIMARY KEY (`Abteilungsnummer`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `abteilung`
--

LOCK TABLES `abteilung` WRITE;
/*!40000 ALTER TABLE `abteilung` DISABLE KEYS */;
INSERT INTO `abteilung` VALUES (1,'Forschungsabteilung','10. UG');
/*!40000 ALTER TABLE `abteilung` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mitarbeiter`
--

DROP TABLE IF EXISTS `mitarbeiter`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mitarbeiter` (
  `Svn` int NOT NULL,
  `Name` varchar(255) NOT NULL,
  `abteilung_abteilungsnummer_fk` int DEFAULT NULL,
  `vorgesetzter_fk` int DEFAULT NULL,
  PRIMARY KEY (`Svn`),
  KEY `fk_abteilung_idx` (`abteilung_abteilungsnummer_fk`),
  KEY `fk_vorgesetzter_idx` (`vorgesetzter_fk`),
  CONSTRAINT `fk_abteilung` FOREIGN KEY (`abteilung_abteilungsnummer_fk`) REFERENCES `abteilung` (`Abteilungsnummer`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `fk_vorgesetzter` FOREIGN KEY (`vorgesetzter_fk`) REFERENCES `mitarbeiter` (`Svn`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mitarbeiter`
--

LOCK TABLES `mitarbeiter` WRITE;
/*!40000 ALTER TABLE `mitarbeiter` DISABLE KEYS */;
INSERT INTO `mitarbeiter` VALUES (123,'Walter',1,NULL),(124,'Gyula',1,123);
/*!40000 ALTER TABLE `mitarbeiter` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mitarbeiterprojekt`
--

DROP TABLE IF EXISTS `mitarbeiterprojekt`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mitarbeiterprojekt` (
  `Mitarbeiter_Svn_fk` int NOT NULL,
  `Projekt_ProjektName_fk` varchar(30) NOT NULL,
  `von` datetime NOT NULL,
  `bis` datetime DEFAULT NULL,
  PRIMARY KEY (`Mitarbeiter_Svn_fk`,`Projekt_ProjektName_fk`,`von`),
  KEY `fk_projekt_idx` (`Projekt_ProjektName_fk`),
  CONSTRAINT `fk_mitarbeiter` FOREIGN KEY (`Mitarbeiter_Svn_fk`) REFERENCES `mitarbeiter` (`Svn`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_projekt` FOREIGN KEY (`Projekt_ProjektName_fk`) REFERENCES `projekt` (`ProjektName`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mitarbeiterprojekt`
--

LOCK TABLES `mitarbeiterprojekt` WRITE;
/*!40000 ALTER TABLE `mitarbeiterprojekt` DISABLE KEYS */;
INSERT INTO `mitarbeiterprojekt` VALUES (123,'Mittelmehr','2022-12-01 16:00:00','2022-12-01 17:00:00'),(124,'GetToTheChopper!','2022-11-29 08:00:00',NULL);
/*!40000 ALTER TABLE `mitarbeiterprojekt` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `projekt`
--

DROP TABLE IF EXISTS `projekt`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `projekt` (
  `ProjektName` varchar(30) NOT NULL,
  `Startdatum` date DEFAULT NULL,
  `Enddatum` date DEFAULT NULL,
  PRIMARY KEY (`ProjektName`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `projekt`
--

LOCK TABLES `projekt` WRITE;
/*!40000 ALTER TABLE `projekt` DISABLE KEYS */;
INSERT INTO `projekt` VALUES ('GetToTheChopper!','2022-11-29','2023-11-29'),('Mittelmehr','2022-12-01','2022-12-01');
/*!40000 ALTER TABLE `projekt` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2022-11-29  9:24:38
